/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.ColumnVariable;
import org.codefilarete.stalactite.sql.order.Insert;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterIndex;
import org.codefilarete.tool.collection.KeepOrderSet;

public class InsertCommandBuilder<T extends Table<T>>
implements SQLBuilder {
    private final Insert<T> insert;
    private final Dialect dialect;

    public InsertCommandBuilder(Insert<T> insert, Dialect dialect) {
        this.insert = insert;
        this.dialect = dialect;
    }

    @Override
    public String toSQL() {
        KeepOrderSet columns = this.insert.getRow().stream().map(ColumnVariable::getColumn).collect(Collectors.toCollection(KeepOrderSet::new));
        ColumnParameterizedSQL columnParameterizedSQL = this.dialect.getDmlGenerator().buildInsert(columns);
        return columnParameterizedSQL.getSQL();
    }

    public InsertStatement<T> toStatement() {
        KeepOrderSet columns = this.insert.getRow().stream().map(ColumnVariable::getColumn).collect(Collectors.toCollection(KeepOrderSet::new));
        ColumnParameterizedSQL columnParameterizedSQL = this.dialect.getDmlGenerator().buildInsert(columns);
        PreparedStatementWriterIndex parameterBinderProvider = columnParameterizedSQL.getParameterBinderProvider();
        InsertStatement result = new InsertStatement(parameterBinderProvider, columnParameterizedSQL);
        this.insert.getRow().forEach(c -> result.setValue(c.getColumn(), c.getValue()));
        return result;
    }

    public static class InsertStatement<T extends Table<T>>
    extends SQLStatement<Column<T, ?>> {
        private final ColumnParameterizedSQL<T> columnParameterizedSQL;

        private InsertStatement(PreparedStatementWriterIndex<Column<T, ?>, PreparedStatementWriter<?>> parameterBinderProvider, ColumnParameterizedSQL<T> columnParameterizedSQL) {
            super(parameterBinderProvider);
            this.columnParameterizedSQL = columnParameterizedSQL;
        }

        public String getSQL() {
            return this.columnParameterizedSQL.getSQL();
        }

        protected void doApplyValue(Column<T, ?> key, Object value, PreparedStatement statement) {
            PreparedStatementWriter paramBinder = this.getParameterBinder(key);
            if (paramBinder == null) {
                throw new SQLStatement.BindingException("Can't find a " + ParameterBinder.class.getName() + " for column " + key.getAbsoluteName() + " of value " + value + " on sql : " + this.getSQL());
            }
            this.doApplyValue(this.columnParameterizedSQL.getColumnIndexes().get(key)[0], value, paramBinder, statement);
        }
    }
}

